using Microsoft.AspNetCore.Mvc;
using System.Text.Json;
using System.Text.Json.Serialization;
using System.Xml;

namespace QTCProject.Models
{
    [Route("api/[controller]")]
    [ApiController]
    public class APIController : ControllerBase
    {
        private readonly RSACrypt _rsa = new RSACrypt();
        private readonly Vault _vault = new Vault();

        /** Custom API used to demonstrate that application can send to an endpoint, and that the receiver can decrypt it

            @parameter data: JSON file holding received siphertext
        */
        [HttpPost]
        public IActionResult ReceiveData([FromBody] JsonElement data)
        {
            // Display received data on console
            Console.WriteLine("Received encrypted data:");
            for (int i = 0; i < data.GetArrayLength(); i++) Console.WriteLine(data[i]);

            Console.WriteLine("Decrypted data");
            string privateKey = _vault.GetPublicOrPrivateKey("privateRSA");
            for (int i = 0; i < data.GetArrayLength(); i++)
            {
                Patient patient = JsonSerializer.Deserialize<Patient>(data[i]);
                string stringKeyIV = _rsa.Decrypt(patient.SessionKey, privateKey);
                string[] splitKeyIV = stringKeyIV.Split(",");
                (byte[] aesKey, byte[] aesIV) = (Convert.FromBase64String(splitKeyIV[0]), Convert.FromBase64String(splitKeyIV[1]));

                foreach (var prop in patient.GetType().GetProperties().Where(p => p.Name != "SessionKey"))
                {
                    var value = prop.GetValue(patient) == null ? null : AESCrypt.Decrypt(Convert.FromBase64String(prop.GetValue(patient).ToString()), aesKey, aesIV);
                    prop.SetValue(patient, value);
                }
                patient.SessionKey = stringKeyIV;
                
                string unencrypted = JsonSerializer.Serialize<Patient>(patient, new JsonSerializerOptions{ WriteIndented = true});
                Console.WriteLine(unencrypted.ToString());
            }

            // Code below decrypts received data, used for debuggin
            
            return Ok("Data received successfully");
        }
    }
}
