using Microsoft.AspNetCore.Mvc;
using QTCProject.Models;
public class PatientsController : Controller
{
    private PatientDataAccess _patientDataAccess;
    private readonly string _connectionString;

    public PatientsController(IConfiguration configuration)
    {
        _connectionString = configuration.GetConnectionString("MyDatabase")!;
        _patientDataAccess = new PatientDataAccess(_connectionString);

    }

    // GET: Patient/InputData
    public ActionResult InputData()
    {
        return View();
    }

    // POST: Patient/InputData
    [HttpPost]
    [ValidateAntiForgeryToken] // Protects against CSRF attacks
    public ActionResult GenerateData(Patient patient)
    {

        if(!ModelState.IsValid)
        {
            return View("InputData", patient);
        }

        _patientDataAccess.AddPatient(patient);
        Console.WriteLine("Patient added successfully");
        return RedirectToAction("InputData");
    }

    // GET: Patient/SearchPatient
    [HttpGet]
    public IActionResult SearchPatient()
    {
        return View(new List<Patient>()); // Initially pass an empty list to the view
    }
    
    // POST: Patient/SearchPatient
    [HttpPost]
    [ValidateAntiForgeryToken]
    public ActionResult SearchPatient(string searchString)
    {
        var patients = _patientDataAccess.SearchPatient(searchString);
        return View(patients);
    }

    //POST: Patient/SendData
    [HttpPost]
    [ValidateAntiForgeryToken]
    public async Task<ActionResult> SendDataAsync(Patient patient, string action)
    {
        await _patientDataAccess.SendByForm(patient, action);
        return RedirectToAction("InputData");
    }

    [HttpPost]
    [ValidateAntiForgeryToken]
    public async Task<ActionResult> SendSelectedPatient(string[] selectedPatients, string action)
    {
        await _patientDataAccess.SendByDatabase(selectedPatients, action);
        return RedirectToAction("SearchPatient");
    }
}
