//use AES encryption algorithm to encrypt and decrypt data
//use the built-in .Net cryptography library
//input will take the SSN and output will be the encrypted SSN

using System.Security.Cryptography;

public class AESCrypt
{
    public static (byte[], byte[]) GenerateSecureAESKeyAndIV(int keySize = 256, int ivSize = 128)
    {
        var key = new byte[keySize / 8];
        RandomNumberGenerator.Fill(key);
        var iv = new byte[ivSize / 8];
        RandomNumberGenerator.Fill(iv);
        return (key, iv);
    }

    // Encrypts plaintext using AES with the provided key and IV
    public static byte[] Encrypt(string plainText, byte[] Key, byte[] IV)
    {
        using (Aes aesAlg = Aes.Create())
        {
            aesAlg.Key = Key;
            aesAlg.IV = IV;
            ICryptoTransform encryptor = aesAlg.CreateEncryptor(aesAlg.Key, aesAlg.IV);

            using (var msEncrypt = new MemoryStream())
            {
                using (var csEncrypt = new CryptoStream(msEncrypt, encryptor, CryptoStreamMode.Write))
                using (var swEncrypt = new StreamWriter(csEncrypt))
                {
                    swEncrypt.Write(plainText);
                } // Ensure the StreamWriter and CryptoStream are flushed and closed here.

                // After writing and closing the CryptoStream, the data is written to the MemoryStream.
                return msEncrypt.ToArray(); // This should now correctly contain the encrypted data.
            }
        }
    }

    // Decrypts ciphertext using AES with the provided key and IV
    public static string Decrypt(byte[] cipherText, byte[] Key, byte[] IV)
    {
        using (Aes aesAlg = Aes.Create())
        {
            aesAlg.Key = Key;
            aesAlg.IV = IV;
            ICryptoTransform decryptor = aesAlg.CreateDecryptor(aesAlg.Key, aesAlg.IV);

            using (var msDecrypt = new MemoryStream(cipherText))
            using (var csDecrypt = new CryptoStream(msDecrypt, decryptor, CryptoStreamMode.Read))
            using (var srDecrypt = new StreamReader(csDecrypt))
            {
                return srDecrypt.ReadToEnd();
            }
        }
    }
}
