using Quartz;
using Quartz.Impl;


class KeyRotationJob : IJob
{
    
    public async Task Execute(IJobExecutionContext context)
    {
        // Assuming PatientDataAccess has a static method or you have a way to access it here
        var _vault = new Vault();
        await Task.Run(() => _vault.RotateAESKeys());
    }
}

class SimpleLoggingJob : IJob // Define the new SimpleLoggingJob class
{
    public Task Execute(IJobExecutionContext context)
    {
        Console.WriteLine($"SimpleLoggingJob executed at: {DateTime.Now}");
        return Task.CompletedTask;
    }
}

class SchedulerManager
{
    public static async Task InitializeScheduler()
    {
        ISchedulerFactory schedulerFactory = new StdSchedulerFactory();
        IScheduler scheduler = await schedulerFactory.GetScheduler();
        await scheduler.Start();

        // Schedule the KeyRotationJob
        IJobDetail keyRotationJob = JobBuilder.Create<KeyRotationJob>()
            .WithIdentity("KeyRotationJob", "group1")
            .Build();

        ITrigger keyRotationTrigger = TriggerBuilder.Create()
            .WithIdentity("triggerKeyRotationJob", "group1")
            .StartNow()
            .WithSimpleSchedule(x => x.WithIntervalInHours(24).RepeatForever())
            .Build();

        await scheduler.ScheduleJob(keyRotationJob, keyRotationTrigger);

        // Schedule the SimpleLoggingJob
        IJobDetail simpleLoggingJob = JobBuilder.Create<SimpleLoggingJob>()
            .WithIdentity("SimpleLoggingJob", "group1")
            .Build();

        ITrigger simpleLoggingTrigger = TriggerBuilder.Create()
            .WithIdentity("triggerSimpleLoggingJob", "group1")
            .StartNow()
            .WithSimpleSchedule(x => x.WithIntervalInMinutes(1).RepeatForever()) // For demonstration, logs every minute
            .Build();

        await scheduler.ScheduleJob(simpleLoggingJob, simpleLoggingTrigger);
    }
}

// Entry point or a part where you would initialize the application
public partial class Program
{
    public static async Task Main(string[] args)
    {
        await SchedulerManager.InitializeScheduler();
    }
}
