using Azure.Identity;
using Azure.Security.KeyVault.Secrets;

public class Vault
{
    private SecretClient secretClient;
    private static string vaultUri = "https://testvaultqtc.vault.azure.net/";
    private static string tenantID = "ce8a2002-448f-4f58-82b1-d86f73e3afdd";
    private static string clientID = "b068eafd-f4ed-44e8-94f7-b2973d67a4eb";
    private static string clientSecret = "dDk8Q~hS-Dl0r.3pZJx~ocBUW~ugmp71Q_BLOb3h";
    private ClientSecretCredential appCredentials = new ClientSecretCredential(tenantID, clientID, clientSecret);

    private static int currentKeyIndex = 0;
    private static readonly int totalKeys = 5;
    
    /** Initializes an instance of the Vault Class while establishing 
        a connection to an Azure Key Vault using the above credentials.
    */
    public Vault()
    {
        secretClient = new SecretClient(new Uri(vaultUri), appCredentials);
    }

    /** Retrieves an AES key from Azure Key Vault

        @parameter secretName: name of the key to retrieve
        @parameter version: version of the key to retrieve

        @return secret: string representation of the AES key
    */
    public string GetSessionKey(string secretName, string? version = null)
    {
        KeyVaultSecret secret = version != null ? secretClient.GetSecret(secretName, version) : secretClient.GetSecret(secretName);
        return secret.Value;
    }

    /** Stores an AES key into Azure Key Vault

        @parameter secretName: name under which the key will be stored in the vault, even if it already exists in the vault
        @parameter aesKey: byte array of the AES key
        @parameter aesIV: byte array of the AES IV
    */
    public void StoreSessionKey(string secretName, byte[] aesKey, byte[] aesIV)
    {
        string stringkey = Convert.ToBase64String(aesKey);
        string stringiv = Convert.ToBase64String(aesIV);
        string combined = stringkey + "," + stringiv;
        secretClient.SetSecret(secretName, combined);
    }

    /** Retrieves an RSA key from Azure Key Vault

        @parameter secretName: string name of the RSA key to retrieve

        @return secret: string representation of the RSA key
    */
    public string GetPublicOrPrivateKey(string secretName)
    {
        KeyVaultSecret secret = secretClient.GetSecret(secretName);
        return secret.Value;
    }

    /** Stores an RSA key into Azure Key Vault

        @parameter secretName: name under which the key will be stored in the vault, even if it already exists in the vault
        @parameter secretValue: string representation of the key
    */
    public void StorePublicOrPrivateKey(string secretName, string secretValue)
    {
        secretClient.SetSecret(secretName, secretValue);
    }

    /** Returns the name of an AES key to retrieve from Azure Key Vault

        @return string: composition of AES keys name and the number of the specific key
    */
    public string GetCurrentKey()
    {
        return $"SessionKey{currentKeyIndex}";
    }

    /** Cycles through the AES key names in the Azure Key Vault
    */
    public void RotateAESKeys()
    {
        // Loop through keys 1-5
        currentKeyIndex = currentKeyIndex % totalKeys + 1;
        string keyName = $"SessionKey{currentKeyIndex}"; 
        Console.WriteLine("Now using " + keyName);
    }
}