using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace QTCProject.Models
{
    public class Patient
    {
        [Key]
        [DatabaseGenerated(DatabaseGeneratedOption.Identity)]//If MemberID is auto-generated  by the database
        public string? MemberId { get; set; }

        [StringLength(25)]
         [Required(ErrorMessage = "First name is required")]
        public string FirstName { get; set; }

        [StringLength(25)]
         [Required(ErrorMessage = "Last name is required")]
        public string LastName { get; set; }

        [StringLength(11)]
          [Required(ErrorMessage = "SSN is required")]
        public string SSN { get; set; }

        [StringLength(10)]
        [Required(ErrorMessage = "Date of Birth is required")]
        public string? DOB { get; set; }

        [StringLength(1)]
        public string? MiddleInitial { get; set; }

        [StringLength(1)]
         [Required (ErrorMessage = "Gender Field is required")]
        public string Gender { get; set; }

        [StringLength(50)]
         [Required(ErrorMessage = "Email is required")]
        public string Email { get; set; }

        [Required(ErrorMessage = "Cell phone is required")]
        public string CellPhone { get; set; }
        
        [StringLength(1000)]
        public string? SessionKey { get; set; }
    }
}
